/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.base.VWDebug;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class VWTaskClassLoader
extends URLClassLoader {
    private HashMap m_classes = new HashMap();
    private String m_packageName = null;

    public static VWTaskClassLoader getInstance(String classpath, String packageName) {
        VWDebug.logInfo("Constructing VWTaskClassLoader from classpath: " + classpath);
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator, false);
        ArrayList<URL> urls = new ArrayList<URL>();
        HashMap pathMap = new HashMap();
        while (tokens.hasMoreTokens()) {
            String path = null;
            try {
                path = VWTaskUtil.getWindowsShortPath(tokens.nextToken().trim(), pathMap);
                URL url = new File(path).toURL();
                VWDebug.logInfo("Classpath URL: " + url.toString());
                urls.add(url);
            }
            catch (MalformedURLException ex) {
                VWDebug.logException(ex, "Exception creating URL for classpath item: " + path);
            }
        }
        return new VWTaskClassLoader(urls.toArray(new URL[urls.size()]), packageName);
    }

    public VWTaskClassLoader(URL[] urls, String packageName) {
        super(urls);
        this.m_packageName = packageName;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.m_classes.containsKey(name)) {
            return (Class)this.m_classes.get(name);
        }
        Class<?> theClass = super.findClass(name);
        this.m_classes.put(name, theClass);
        return theClass;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.byPassDelegation(name)) {
            return this.findClass(name);
        }
        return super.loadClass(name);
    }

    public Class loadClass(String name, boolean resolveit) throws ClassNotFoundException {
        if (this.byPassDelegation(name)) {
            return this.findClass(name);
        }
        return super.loadClass(name, resolveit);
    }

    private boolean byPassDelegation(String className) {
        return className.startsWith(this.m_packageName);
    }
}

